<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\MediumWithStaticPreviewUri;

class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface, MediumWithStaticPreviewUri
{

    public function getSourceUri(): string
    {
        return $this->object['url'];
    }

    public function getTitle(): ?string
    {
        return $this->object['name'];
    }

    public function getCopyright(): ?string
    {
        return $this->object['copyright'];
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }

    public function getPreviewUri(): ?string
    {
        return $this->object['sizes']['preview']['image/jpeg'] ?? $this->object['preview']['image/jpeg'] ?? null;
    }

    public function getAltText(): ?string
    {
        return $this->object['altText'] ?? null;
    }

    public function getDescription(): ?string
    {
        return $this->object['description'] ?? null;
    }

    public function getFocusPointX(): ?int
    {
        return $this->object['focusPoint']['x'] ?? null;
    }

    public function getFocusPointY(): ?int
    {
        return $this->object['focusPoint']['y'] ?? null;
    }
}
