<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use DateTimeInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;

class EventDateAdapter extends AbstractObjectAdapter implements EventDateAdapterInterface
{
    use EventCommon;

    public function getBeginsAt(): ?DateTimeInterface
    {
        return $this->buildDateTimeFromStrings($this->object['date'], $this->object['startAt'] ?? '00:00');
    }

    public function getEndsAt(): ?DateTimeInterface
    {
        return $this->buildDateTimeFromStrings($this->object['date'], $this->object['endAt'] ?? '23:59');
    }

    public function getBeginsAtSpecificTime(): bool
    {
        return $this->object['date'] !== null && $this->object['startAt'] !== null;
    }

    public function getEndsAtSpecificTime(): bool
    {
        return $this->object['date'] !== null && $this->object['endAt'] !== null;
    }

    public function getNote(): string
    {
        return $this->object['additionalInformation'];
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }

    public function isCancelled(): bool
    {
        return $this->object['isCancelled'];
    }

    public function isActive(): bool
    {
        return $this->object['active'];
    }

    public function hasDate(): bool
    {
        return $this->object['date'] !== null;
    }
}
