<?php
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;
use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;

/**
 * Category adapter.
 */
class CategoryAdapter extends AbstractObjectAdapter implements CategoryAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE . '_' . (string) $this->object['id'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return strip_tags((string) $this->object['name']);
    }
}
