<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\WeatherSymbol;

class SymbolAdapter
{
    const ICON_MAP = [
        '01' => WeatherSymbol::SUNNY,
        '02' => WeatherSymbol::MOSTLY_SUNNY,
        '03' => WeatherSymbol::CLOUDY,
        '04' => WeatherSymbol::HEAVY_CLOUDS,
        '09' => WeatherSymbol::HEAVY_RAIN,
        '10' => WeatherSymbol::RAIN,
        '11' => WeatherSymbol::THUNDERSTORM,
        '13' => WeatherSymbol::SNOW,
        '50' => WeatherSymbol::FOG,
    ];

    /** @var string */
    protected $defaultName = 'na';

    public function getClass(string $icon): string
    {
        $iconId = $this->getIconIndex($icon);

        return $this->getIconName($iconId);
    }

    private function getIconIndex(string $icon): string
    {
        $iconIndex = '';
        if (preg_match('/(\d*)[dn]/', $icon, $matches)) {
            $iconIndex = $matches[1];
        }

        return $iconIndex;
    }

    private function getIconName(string $iconIndex): string
    {
        $name = $this->defaultName;
        if (array_key_exists($iconIndex, self::ICON_MAP)) {
            $name = self::ICON_MAP[$iconIndex];
        }

        return $name;
    }
}
