<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

class HourAdapter implements HourAdapterInterface
{
    /**
     * @var SymbolAdapter
     */
    private $symbolAdapter;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var int
     */
    private $time;
    /**
     * @var float
     */
    private $temperature;
    /**
     * @var float
     */
    private $minimumTemperature;
    /**
     * @var float
     */
    private $maximumTemperature;
    /**
     * @var string
     */
    private $symbol;

    public function __construct(array $data)
    {
        $this->symbolAdapter = new SymbolAdapter();
        $this->parseData($data);
    }

    private function parseData(array $data): void
    {
        $date = \DateTime::createFromFormat('U', $data['dt']);
        if ($date) {
            $this->date = $date;
        }
        $this->time = (int) $this->date->format('G');
        $this->temperature = (int) $data['main']['temp'];
        $this->minimumTemperature = (int) $data['main']['temp_min'];
        $this->maximumTemperature = (int) $data['main']['temp_max'];
        $this->symbol = $this->symbolAdapter->getClass($data['weather'][0]['icon']);
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * The hour of the time in 0 - 23 format.
     *
     * @return int
     */
    public function getTime(): int
    {
        return $this->time;
    }

    public function getTemperature(): float
    {
        return $this->temperature;
    }

    public function getMinimumTemperature(): float
    {
        return $this->minimumTemperature;
    }

    public function getMaximumTemperature(): float
    {
        return $this->maximumTemperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getExternalId(): string
    {
        return '';
    }
}
