<?php
namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;
use Newland\Toubiz\Api\Service\Weather\ObjectAdapter\AbstractDayAdapter;

class DayAdapter extends AbstractDayAdapter implements DayAdapterInterface
{
    /**
     * @var HourAdapter[]
     */
    protected $hours;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var float
     */
    private $maximumTemperature = 0;
    /**
     * @var float
     */
    private $minimumTemperature = 0;
    /**
     * @var string
     */
    private $symbol = '';
    /**
     * @var int
     */
    private $sunshineDuration = 0;

    public function __construct(string $dateString, array $data)
    {
        $this->date = new \DateTime($dateString);
        $this->parseData($data);
    }

    private function parseData(array $data): void
    {
        foreach ($data as $dateString => $hourItem) {
            $this->hours[] = new HourAdapter($dateString, $hourItem);
        }
        $this->symbol = $this->getGeneralSymbol();
        $this->sunshineDuration = $this->calculateSunshineDuration($data);

        $maximumTemperature = $this->calculateMaximumTemperature();
        if ($maximumTemperature) {
            $this->maximumTemperature = $maximumTemperature;
        }

        $minimumTemperature = $this->calculateMinimumTemperature();
        if ($minimumTemperature) {
            $this->minimumTemperature = $minimumTemperature;
        }
    }

    protected function calculateSunshineDuration(array $data): int
    {
        $duration = 0;
        foreach ($data as $hourItem) {
            $duration += (int) $hourItem['ss'];
        }

        return $duration;
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getAllHours(): array
    {
        return $this->hours;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getMainHours(): array
    {
        $mainHours = [];

        if (\count($this->hours) === 24) {
            $mainHours = [
                $this->hours[6],
                $this->hours[9],
                $this->hours[12],
                $this->hours[15],
                $this->hours[18],
                $this->hours[21],
            ];
        }

        return $mainHours;
    }

    public function getHoursForCalculation(): array
    {
        $mainHours = [];

        if (\count($this->hours) === 24) {
            $mainHours = [
                $this->hours[0],
                $this->hours[6],
                $this->hours[12],
                $this->hours[18],
            ];
        }

        return $mainHours;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getMainHoursPadded(): array
    {
        return $this->getMainHours();
    }

    public function getMaximumTemperature(): float
    {
        return $this->maximumTemperature;
    }

    public function getMinimumTemperature(): float
    {
        return $this->minimumTemperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getSunshineDuration(): int
    {
        return $this->sunshineDuration;
    }

    public function getExternalId(): string
    {
        return '';
    }

    public function hasSunshineDurationData(): bool
    {
        return true;
    }
}
