<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Meteogroup\ObjectAdapters;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Weather\WeatherSymbol;

class DayAdapter extends AbstractObjectAdapter implements DayAdapterInterface
{

    /** @var array<int, string> */
    protected $symbolMap = [
        // Sunny
        '1' => WeatherSymbol::SUNNY,

        // Slightly cloudy
        '2' => WeatherSymbol::CLOUDY,

        // Partly cloudy
        '3' => WeatherSymbol::CLOUDY,

        // Cloudy
        '4' => WeatherSymbol::CLOUDY,

        // Rain
        '5' => WeatherSymbol::RAIN,

        // Sleet / Schneeregen
        '6' => WeatherSymbol::SNOW,

        // Snow
        '7' => WeatherSymbol::SNOW,

        // Hail
        '8' => WeatherSymbol::HEAVY_RAIN,

        // shower
        '9' => WeatherSymbol::HEAVY_RAIN,

        // snow shower
        '10' => WeatherSymbol::SNOW,

        // sleet shower
        '11' => WeatherSymbol::SNOW,

        // fog
        '12' => WeatherSymbol::FOG,

        // thick fog
        '13' => WeatherSymbol::FOG,

        // danger of ice
        '14' => WeatherSymbol::UNKNOWN,

        // thunderstorm
        '15' => WeatherSymbol::HEAVY_RAIN,

        // drizzle
        '16' => WeatherSymbol::RAIN,

        // sandstorm
        '17' => WeatherSymbol::UNKNOWN,

        // wet and cold
        '18' => WeatherSymbol::HEAVY_CLOUDS,

        // dry
        '19' => WeatherSymbol::SUNNY,

        // sunny
        '20' => WeatherSymbol::SUNNY,

        // slightly cloudy
        '21' => WeatherSymbol::CLOUDY,

        // partly cloudy
        '22' => WeatherSymbol::CLOUDY,

        // cloudy
        '23' => WeatherSymbol::CLOUDY,

        // rain
        '24' => WeatherSymbol::RAIN,

        // sleet
        '25' => WeatherSymbol::SNOW,

        // snow
        '26' => WeatherSymbol::SNOW,

        // hail
        '27' => WeatherSymbol::SNOW,

        // shower
        '28' => WeatherSymbol::HEAVY_RAIN,

        // snow shower
        '29' => WeatherSymbol::SNOW,

        // sleet shower
        '30' => WeatherSymbol::SNOW,

        // fog
        '31' => WeatherSymbol::FOG,

        // thick fog
        '32' => WeatherSymbol::FOG,

        // danger of ice
        '33' => WeatherSymbol::SNOW,

        // thunderstorm
        '34' => WeatherSymbol::HEAVY_RAIN,

        // drizzle
        '35' => WeatherSymbol::RAIN,

        // sandstorm
        '36' => WeatherSymbol::UNKNOWN,

        // wet and cold
        '37' => WeatherSymbol::HEAVY_CLOUDS,

        // dry
        '38' => WeatherSymbol::SUNNY,
    ];

    public function getDate(): \DateTime
    {
        return new \DateTime($this->object['date']);
    }

    public function getAllHours(): array
    {
        return [];
    }

    public function getMainHours(): array
    {
        return [];
    }

    public function getMainHoursPadded(): array
    {
        return [];
    }

    public function getMaximumTemperature(): float
    {
        return (float) ($this->object['Temperatur-Maximum'] ?? 0.0);
    }

    public function getMinimumTemperature(): float
    {
        return (float) ($this->object['Temperatur-Minimum'] ?? 0.0);
    }

    public function getSymbol(): string
    {
        $rawSymbol = $this->object['Wettersymbol'] ?? '';
        return $this->symbolMap[$rawSymbol] ?? '';
    }

    public function hasSunshineDurationData(): bool
    {
        return ($this->object['Sonnenscheindauer'] ?? null) !== null;
    }

    public function getSunshineDuration(): int
    {
        $hours = $this->object['Sonnenscheindauer'] ?? null;
        if (!$hours) {
            return 0;
        }

        return (int) $hours * 60;
    }

    public function getExternalId(): string
    {
        return 'meteogroup_' . $this->object['date'];
    }
}
