<?php
namespace Newland\Toubiz\Api\Redirect;

use GuzzleHttp\Psr7\Response;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\BrochureRedirectUriConverter;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use function Safe\json_encode;

class ToubizBrochureNormalizationRedirectHandler implements RedirectHandler
{
    public static function type(): string
    {
        return 'toubiz_brochure';
    }

    public function handle(RequestInterface $request): ResponseInterface
    {
        $path = $request->getUri()->getPath();
        $result = (new BrochureRedirectUriConverter())->convert($path);
        $payload = json_encode([ 'path' => $path, 'result' => $result ]);

        return new Response($result->isSuccess() ? 200 : 500, [ 'Content-Type' => 'application/json' ], $payload);
    }
}
