<?php
namespace Newland\Toubiz\Api\Redirect;

class RedirectHandlerFactory
{

    /**
     * @var array
     */
    private $classMap;

    public function __construct()
    {
        $this->addClasses([ ToubizBrochureNormalizationRedirectHandler::class ]);
    }

    public function addClass(string $className): void
    {
        if (!\in_array(RedirectHandler::class, class_implements($className), true)) {
            throw new \InvalidArgumentException(
                sprintf('Class %s does not implement interface %s', $className, RedirectHandler::class)
            );
        }

        $this->classMap[$className::type()] = $className;
    }

    public function addClasses(array $classNames): void
    {
        foreach ($classNames as $className) {
            $this->addClass($className);
        }
    }

    public function getRedirectHandler(string $type): ?RedirectHandler
    {
        if (!array_key_exists($type, $this->classMap)) {
            return null;
        }

        $class = $this->classMap[$type];
        return new $class();
    }
}
