<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\ObjectAdapter;

interface ServiceAdapterInterface extends ObjectAdapterInterface
{
    public function setDetailUriTemplate(?string $template): void;
    public function getDetailUri(): string;
    public function getType(): string;
    public function getName(): string;
    public function getMinimumNights(): ?float;
    public function getStartingPrice(): ?float;
    public function getStartingPriceCurrency(): ?string;
    public function getDurationMinutes(): ?int;
    public function getAddress(): ?string;
    public function getDescription(): ?string;

    /** @return MediumAdapterInterface[] */
    public function getMedia(): array;

    /** @return string[] */
    public function getBenefits(): array;
}
