<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * File adapter interface.
 *
 * Defines the interface for all file adapters
 * representing a downloadable file attached to another record.
 */
interface FileAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the title of the download.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the source URI.
     *
     * @return string
     */
    public function getSourceUri();
}
