<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Attributes;

interface TourAttributes
{
    /**
     * Name of the data source.
     * Value must be one of the `DATA_SOURCE_*` constants.
     */
    const DATA_SOURCE = 'dataSource';
    const DATA_SOURCE_OUTDOOR_ACTIVE = 'outdooractive';
    const DATA_SOURCE_TOUBIZ_LEGACY = 'toubizLegacy';

    /**
     * Id of the article at the external data source.
     */
    const DATA_SOURCE_ID = 'dataSourceId';

    /**
     * Status of a tour: open or closed.
     */
    const STATUS = 'status';

    /**
     * Special information concerning the status of a tour.
     */
    const CURRENT_INFO = 'currentInfo';


    const PUBLIC_TRANSPORT_FRIENDLY = 'publicTransportFriendly';

    /**
     * Length of the tour in meters.
     */
    const TOUR_LENGTH = 'tourLength';

    /**
     * Duration of the tour in minutes.
     */
    const TOUR_DURATION = 'tourDuration';

    const TECHNIQUE_RATING = 'techniqueRating';
    const LANDSCAPE_RATING = 'landscapeRating';
    const EXPERIENCE_RATING = 'experienceRating';
    const DIFFICULTY_RATING = 'difficultyRating';
    const CONDITION_RATING = 'conditionRating';

    const STARTING_POINT = 'startingPoint';
    const ENDING_POINT = 'endingPoint';
    const PRIVATE_TRANSIT = 'privateTransit';
    const PUBLIC_TRANSIT = 'publicTransit';
    const APPROACH = 'approach';
    const MAPS = 'maps';

    /**
     * Various tag-like properties.
     * Must receive an array of multiple string values.
     */
    const PROPERTIES = 'properties';
    const PROPERTIES_SUITABLE_FOR_PREAMBULATORS = 'suitableforperambulators';
    const PROPERTIES_SUITABLE_FOR_WHEELCHAIRS = 'wheelchairSuitable';

    /**
     * Minimum altitude of the tour in meters.
     */
    const MINIMUM_ALTITUDE = 'minimumAltitude';

    /**
     * Maximum altitude of the tour in meters.
     */
    const MAXIMUM_ALTITUDE = 'maximumAltitude';

    /**
     * Geometry: Array of points in the following format:
     * ```
     * [
     *      [ latitude, longitude ],
     *      [ latitude, longitude ],
     *      ...
     * ]
     * ```
     */
    const GEOMETRY = 'geometry';

    /**
     * String description of the equipment that is necesarry
     * for the tour.
     */
    const NECESARRY_EQUIPMENT = 'equipment';

    /**
     * Elevation differences in the tour (up & down).
     */
    const ASCEND_ELEVATION = 'ascentElevation';
    const DESCENT_ELEVATION = 'descentElevation';

    /**
     * URL of an image showing the tour's elevation profile.
     */
    const ELEVATION_PROFILE = 'elevationProfile';

    /**
     * Best season to do this tour in.
     * Must be an array of months as identified by `MonthConstants`.
     */
    const BEST_SEASON = 'bestSeason';

    const DIRECTIONS = 'directions';
    const PARKING = 'parking';
    const ADDITIONAL_INFORMATION = 'additionalInformation';
    const HINT_OF_AUTHOR = 'tipOfAuthor';
    const SAFETY_NOTE = 'safetyNote';
    const LITERATURE_TIP_OF_AUTHOR = 'literatureTipOfAuthor';
    const PARTICULARITIES = 'particularities';
    const FEATURE = 'feature';
    /**
     * External link to a 3D Flight
    */
    const FLIGHT_3D = 'flight3d';

    /**
     * External link to a Panorama
    */
    const PANORAMA = 'panorama';

    /**
     * Decoration ist either 'Premiumweg Deutsches Wandersiegel'
     * or 'Qualitätsweg Wanderbares Deutschland'
    */
    const DECORATIONS = 'decorations';

    public const TERRAIN = 'terrain';
    public const SIGN_POSTS = 'signPosts';
}
