<?php declare(strict_types = 1);

namespace Newland\GpsFileParsing\Tests\Parser;

use Newland\GpsFileParsing\Exception\Exception;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Parser\GpxParser;
use PHPUnit\Framework\TestCase;

class GpxParserTest extends TestCase
{

    /** @var GpxParser */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new GpxParser(new XmlFileReader());
    }

    /** @dataProvider provideGpxFiles */
    public function testShouldBeAbleToLoadPointFromGpxFile(string $file): void
    {
        $track = $this->subject->extractTrack($file);
        $this->assertIsArray($track->getPoints());
        $this->assertGreaterThan(0, count($track->getPoints()), 'Should have extracted more than one point');
    }

    public function testDoesNotFailWhenTryingToParseInvalidFile(): void
    {
        $this->expectException(Exception::class);
        $this->subject->extractTrack(__DIR__ . '/../../fixtures/invalid-files/not-xml.txt');
    }

    public function provideGpxFiles(): array
    {
        $dir = __DIR__ . '/../../fixtures/';
        $data = [];
        foreach (glob($dir . '*.gpx') as $file) {
            $name = str_replace([ $dir, '.gpx' ], '', $file);
            $data[$name] = [ $file ];
        }
        return $data;
    }
}
