<?php declare(strict_types=1);

namespace Newland\GpsFileParsing\Parser;

use Newland\GpsFileParsing\Exception\Exception;
use Newland\GpsFileParsing\Helper\XmlFileReader;
use Newland\GpsFileParsing\Model\Point;
use Newland\GpsFileParsing\Model\Track;
use \Geometry as GeoPhpGeometry;

class FileBasedParser implements Parser
{

    /** @var XmlFileReader */
    private $reader;

    public function __construct(XmlFileReader $reader)
    {
        $this->reader = $reader;
    }

    public function extractTrack(string $file): Track
    {
        $fileContents = $this->reader->readAsText($file);

        $track = new Track();

        $geometries = \geoPHP::load($fileContents);
        if (!($geometries instanceof GeoPhpGeometry)) {
            throw new Exception('Could not parse GPS File ' . $file);
        }

        $points = $geometries->getPoints();
        if (isset($points)) {
            foreach ($points as $point) {
                $point = new Point((float) $point->getY(), (float) $point->getX(), (float) ($point->z() ?? 0));
                $track->addPoint($point);
            }
        }

        return $track;
    }
}
