# GPS File Parser

Library for parsing data from GPS tracks (KML & GPX).

## Example

```php
<?php

use Newland\GpsFileParsing\ParserFactory;
use \Newland\GpsFileParsing\Model\Point;

class MyClass {
    private $fileParserFactory;
    
    public function __construct(ParserFactory $fileParserFactory) {
        $this->fileParserFactory = $fileParserFactory;
    }
    
    public function gpsTrackToGoogleMapsArray(string $file): array {
        $track = $this->fileParserFactory->resolveParser($file)->extractTrack($file);
        return $track->mapPoints(function(Point $point) {
            return [ $point->longitude, $point->latitude ];
        });
    }
}
```
