const path = require('path');
const purgecss = require('@fullhuman/postcss-purgecss');

module.exports = () => {
    const env = process.env.NODE_ENV || 'development';
    const prod = env === 'production';

    const config = {
        plugins: [
            require('postcss-import'),
            require('tailwindcss')(process.env.TAILWIND_CONFIG),
            require('autoprefixer'),
        ],
    };

    if (prod) {
        config.plugins.push(
            purgecss({
                content: [
                    path.resolve(__dirname, 'node_modules/@newland/**/*.vue'),
                    path.resolve(__dirname, 'node_modules/v-calendar/src/**/*.vue'),
                ],
                extractors: [
                    {
                        extractor: content => content.match(/[\w-/.:]+(?<!:)/g) || [],
                        extensions: [ 'scss', 'sass', 'css', 'vue', 'md' ],
                    },
                ],
                whitelistPatterns: [
                    /^::v-deep/,
                    /^flatpickr-/,
                    /^gap-/,
                    /^grid-cols-/,
                    /^mapbox/,
                    /^mgl-/,
                    /^mtk-/,
                    /^re-/,
                    /^redactor-/,
                    /^swiper-/,
                    /^tb-w/,
                    /data-v-.*/,
                ],
                whitelist: [
                    'bg-alert',
                    'bg-gray-200',
                    'bg-gray-400',
                    'bg-gray-500',
                    'bg-gray-800',
                    'bg-green-500',
                    'bg-orange-500',
                    'bg-red-500',
                    'border-gray-500',
                    'border-green-500',
                    'border-orange-500',
                    'border-red-500',
                    'border-red-600',
                    'dayContainer',
                    'sr-only',
                    'visually-hidden',
                ],
            }),
        );
    }


    return config;
};
