<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\Tests\Unit\Renderer\Mock;

use Newland\ToubizWidgetRendering\Renderer\ToubizWidgetRenderer;
use Symfony\Component\Console\Output\OutputInterface;

class RendererMock implements ToubizWidgetRenderer
{
    /** @var callable */
    public static $onConfiguration;

    public $configuration;

    /** @var callable */
    public $render;

    /** @var callable */
    public $precompile;

    public function setConfiguration(array $configuration): void
    {
        $this->configuration = $configuration;

        if (static::$onConfiguration) {
            $onConfiguration = static::$onConfiguration;
            $onConfiguration($configuration, $this);
        }
    }

    public function render(string $tagName, array $arguments): string
    {
        $callback = $this->render;
        return $callback($tagName, $arguments);
    }

    public function precompile(OutputInterface $output): void
    {
        $callback = $this->precompile;
        $callback($output);
    }
}
