<?php declare(strict_types=1);

namespace Newland\ToubizWidgetRendering\ViewHelpers;

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\ToubizWidgetRendering\Renderer\ToubizWidgetRenderer;

class RenderDataTemplateViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var ToubizWidgetRenderer
     * @Flow\Inject
     */
    protected $widgetRenderer;

    protected $tagName = 'template';

    public function initializeArguments(): void
    {
        $this->registerArgument('id', 'string', 'The id of the template tag', true);
        $this->registerArgument('payload', 'array', 'The data to be encoded', false, []);
    }

    public function render(): string
    {
        $this->tag->addAttributes(
            [
                'id' => $this->arguments['id'],
                'data-json' => base64_encode(json_encode($this->arguments['payload'])),
            ]
        );

        $this->tag->forceClosingTag(true);
        return $this->tag->render();
    }
}
