<?php
namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Service;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Service\SortingService;

class SortingServiceTest extends FunctionalTestCase
{

    /**
     * @var SortingService
     */
    protected $sortingService;

    public function testSortingByNameIsCorrect()
    {
        $this->sortingService = new SortingService();


        $fruitOrder = [
            'Apple',
            'Banana',
            'Orange',
        ];

        $fruitList = $this->getData();

        $sorted = $this->sortingService->sortObjects($fruitList, 'name', $fruitOrder);

        foreach ($fruitOrder as $i => $order) {
            $this->assertTrue($sorted[$i]->getName() === $order);
        }
    }

    public function testSortingByTypeIsCorrect()
    {
        $this->sortingService = new SortingService();


        $fruitTypeOrder = [
            2,
            0,
            1,
        ];

        $fruitList = $this->getData();

        $sorted = $this->sortingService->sortObjects($fruitList, 'MainType', $fruitTypeOrder);

        foreach ($fruitTypeOrder as $i => $order) {
            $this->assertTrue($sorted[$i]->getMainType() === $order);
        }
    }

    protected function getData()
    {
        $fruitList = [
            'Banana',
            'Apple',
            'Orange',
        ];

        $articles = [];

        foreach ($fruitList as $i => $fruit) {
            $article = new Article();
            $article->setName($fruit);
            $article->setMainType($i);
            $articles[] = $article;
        }
        return $articles;
    }

}
