<?php

use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;
use Newland\Toubiz\Sync\Neos\Service\AttributeCollection;
use Neos\Flow\Tests\FunctionalTestCase;

class AttributeCollectionTest extends FunctionalTestCase
{

    /** @var AttributeCollection */
    private $subject;

    public function setUp(): void
    {
        $this->subject = new AttributeCollection();
        $this->subject->add($this->initializeAttribute('foo', 'foo-data'));
    }

    private function initializeAttribute($name, $data)
    {
        $attribute = new Attribute();
        $attribute->setName($name);
        $attribute->setData($data);
        return $attribute;
    }

    public function testShouldAllowAccessByArrayIndex()
    {
        $this->assertEquals('foo-data', $this->subject[0]);
    }

    public function testShouldAllowAccessByData()
    {
        $this->assertEquals('foo-data', $this->subject['foo-data']);
    }

    public function testShouldAllowIterationOverData()
    {
        $array = [];
        foreach ($this->subject as $key => $value) {
            $array[$key] = $value;
        }
        $this->assertEquals('foo-data', $array[0]);
    }

    public function testShouldOutputStringRepresentation()
    {
        $this->assertEquals('foo-data', (string) $this->subject);
    }

    public function testShouldbeCountable()
    {
        $this->assertInstanceOf(\Countable::class, $this->subject);
        $this->assertEquals(1, \count($this->subject));
    }

}
