<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\ZipCode;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ZipCodeRepository;
use Newland\Toubiz\Sync\Neos\Importer\ZipCodeImporter;
use Newland\Toubiz\Sync\Neos\Service\UuidPredictionService;

class ZipCodeImporterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var ZipCodeImporter */
    protected $subject;

    /** @var ZipCodeRepository */
    protected $zipCodeRepository;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(ZipCodeImporter::class);
        $this->subject->setUuidPredictionService(
            $this->objectManager->get(UuidPredictionService::class)
        );

        $this->zipCodeRepository = $this->objectManager->get(ZipCodeRepository::class);
    }

    public function testImportsZipCode(): void
    {
        $zipCode = $this->subject->import('12345', null);
        $fromRepo = $this->zipCodeRepository->findByIdentifier($zipCode->getPersistenceObjectIdentifier());

        $this->assertNotNull($fromRepo);
        $this->assertEquals('12345', $fromRepo->getZipCode());
        $this->assertEquals(null, $fromRepo->getCountry());
    }

    public function testReusesZipCodeModelIfAlreadyExistsInDatabase(): void
    {
        $zipCode = $this->subject->import('12345', 'DE');
        $another = $this->subject->import('12345', 'DE');

        $this->assertEquals($zipCode->getPersistenceObjectIdentifier(), $another->getPersistenceObjectIdentifier());
    }

    public function testDoesNotReuseZipCodeModelForMultipleCountries(): void
    {
        $zipCode = $this->subject->import('12345', 'DE');
        $another = $this->subject->import('12345', 'US');

        $this->assertNotEquals($zipCode->getPersistenceObjectIdentifier(), $another->getPersistenceObjectIdentifier());
    }

}
