<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;

class WeatherAdapterMock implements WeatherAdapterInterface
{

    public $properties = [];

    public function __construct(array $properties = [])
    {
        $this->properties = $properties;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }

    public function getLocation(): string
    {
        return $this->properties['location'] ?? '';
    }

    public function getForecast(): array
    {
        return $this->properties['forecast'] ?? [];
    }

    public function getLastUpdated(): int
    {
        return $this->properties['lastUpdated'] ?? -1;
    }
}
