<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\ErrorHandling;


use Neos\Error\Messages\Result;
use Neos\Flow\Validation\Error;
use Newland\Toubiz\Sync\Neos\ErrorHandling\ValidationException;
use PHPUnit\Framework\TestCase;

class ValidationExceptionTest extends TestCase
{
    public function testIncludesFlattenedErrors(): void
    {
        $result = new Result();
        $result->forProperty('foo.bar')->addError(new Error('baz'));
        $exception = ValidationException::forResult($result, $this);

        $this->assertArrayHasKey('foo.bar', $exception->getValidationMessages());
        $this->assertEquals('baz', $exception->getValidationMessages()['foo.bar']);
    }
}
