<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Repository;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventDateRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;

class EventDateRepositoryTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var EventDateFactory */
    protected $factory;

    /** @var EventDateRepository */
    protected $eventDateRepository;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new EventDateFactory($this->objectManager);
        $this->eventDateRepository = $this->objectManager->get(EventDateRepository::class);
    }

    public function testDeletingPastRecordsRespectsLanguage(): void
    {
        $english = $this->factory->create([ 'endsAt' => new \DateTime('2019-01-01T13:00:00'), 'language' => 'en' ]);
        $french = $this->factory->create([ 'endsAt' => new \DateTime('2019-01-01T13:00:00'), 'language' => 'fr' ]);

        $this->eventDateRepository->setLanguage('fr');
        $this->eventDateRepository->deletePastRecords(new \DateTime('2019-01-02T16:00:00'));

        $this->eventDateRepository->setLanguage(null);
        $englishFromDatabase = $this->eventDateRepository->findByIdentifier($english->getPersistenceObjectIdentifier());
        self::assertNotNull($englishFromDatabase, 'English record should not have been deleted');

        $frenchFromDatabase = $this->eventDateRepository->findByIdentifier($french->getPersistenceObjectIdentifier());
        self::assertNull($frenchFromDatabase, 'French record should have been deleted');
    }
}
