<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Command\Task;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Command\Helper\ConfigurationHelper;
use Newland\Toubiz\Sync\Neos\Command\Task\SynchronizationTask;

abstract class TaskTestCase extends FunctionalTestCase
{

    /** @var SynchronizationTask */
    protected $subject;

    /** @var ConfigurationHelper */
    protected $configurationHelper;

    abstract protected function className(): string;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get($this->className());
        $this->configurationHelper = $this->objectManager->get(ConfigurationHelper::class);
    }

    public function testAppliesDefaultConfigurationToClientConfiguration(): void
    {
        $this->configurationHelper->setDefaults([ 'foo' => 'bar' ]);
        $configuration = iterator_to_array($this->subject->configurations($this->configurationHelper));
        $this->assertGreaterThan(0, count($configuration));
        foreach ($configuration as $config) {
            $this->assertArrayHasKey('foo', $config);
            $this->assertEquals('bar', $config['foo']);
        }
    }
}
