<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\ZipCode;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ZipCodeRepository;

class ZipCodeFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $zip = new ZipCode();

        $zip->setCountry($properties['country'] ?? $this->faker->countryCode);
        $zip->setZipCode($properties['zipCode'] ?? $this->faker->postcode);

        return $zip;
    }

    /** @param string|int $zipCode */
    public function findOrCreate($zipCode): ZipCode
    {
        $properties = [ 'zipCode' => (string) $zipCode ];
        return $this->objectManager->get(ZipCodeRepository::class)->findOneBy($properties)
            ?? $this->create($properties);
    }

}
