<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Uri;

/**
 * @method Uri create(array $properties = [])
 */
class UriFactory extends AbstractFactory
{
    /**
     * @return Uri
     */
    public function make(array $properties = [])
    {
        $uri = new Uri();

        $uri->setLabel($properties['label'] ?? $this->faker->word);
        $uri->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $uri->setUri($properties['uri'] ?? $this->faker->url);

        return $uri;
    }
}
