<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\TransportationFacility;

/**
 * @method TransportationFacility create(array $properties = [])
 */
class TransportationFacilityFactory extends AbstractFactory
{
    public function make(array $properties = []): TransportationFacility
    {
        $facility = new TransportationFacility();
        $facility->setName($properties['name'] ?? $this->faker->name);
        $facility->setType($properties['type'] ?? 0);
        $facility->setLength($properties['length'] ?? $this->faker->randomNumber());
        $facility->setStatus($properties['status'] ?? 0);
        $facility->setTravelTime($properties['status'] ?? $this->faker->randomNumber());
        $facility->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $facility->setUpdatedAt($properties['updatedAt'] ?? new \DateTime());
        return $facility;
    }
}
