<?php
namespace Newland\Toubiz\Sync\Neos\Geometry;

use Newland\Toubiz\Api\Service\GeoLocation\GeoLocationServiceInterface;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Geometry;
use Newland\Toubiz\Sync\Neos\Domain\Repository\GeometryRepository;

/**
 * @Flow\Scope("singleton")
 */
class LocalLocationService implements GeoLocationServiceInterface
{

    /**
     * @var GeometryRepository
     * @Flow\Inject()
     */
    protected $geometryRepository;

    public function getZipFromGeoLocation(float $lat = null, float $lon = null): string
    {
        if ($lat === null || $lon === null) {
            return '';
        }

        return (string) $this->geometryRepository->labelContainingCoordinates(
            Geometry::TYPE_ZIP,
            $lon,
            $lat
        );
    }
}
