<?php
namespace Newland\Toubiz\Sync\Neos\Geometry;

use CrEOF\Spatial\PHP\Types\AbstractGeometry;
use CrEOF\Spatial\PHP\Types\Geometry\LineString;
use CrEOF\Spatial\PHP\Types\Geometry\MultiLineString;
use CrEOF\Spatial\PHP\Types\Geometry\MultiPoint;
use CrEOF\Spatial\PHP\Types\Geometry\MultiPolygon;
use CrEOF\Spatial\PHP\Types\Geometry\Point;
use CrEOF\Spatial\PHP\Types\Geometry\Polygon;
use GeoIO\Dimension;
use GeoIO\Factory;

/**
 * Factory for object of the creof/doctrine2-spatial package.
 */
class CreofDoctrineSpatialFactory implements Factory
{

    public function create(
        string $type,
        array $properties,
        string $dimension = Dimension::DIMENSION_2D,
        ?int $srid = null
    ): ?AbstractGeometry {
        switch ($type) {
            case AbstractGeometry::POINT:
                return $this->createPoint($dimension, $properties, $srid);
            case AbstractGeometry::LINESTRING:
                return $this->createLineString($dimension, $properties, $srid);
            case AbstractGeometry::POLYGON:
                return $this->createPolygon($dimension, $properties, $srid);
            case AbstractGeometry::MULTIPOINT:
                return $this->createMultiPoint($dimension, $properties, $srid);
            case AbstractGeometry::MULTILINESTRING:
                return $this->createMultiLineString($dimension, $properties, $srid);
            case AbstractGeometry::MULTIPOLYGON:
                return $this->createMultiPolygon($dimension, $properties, $srid);
            default:
                return null;
        }
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createPoint($dimension, array $coordinates, $srid = null): Point
    {
        return new Point($coordinates);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createLineString($dimension, array $points, $srid = null): LineString
    {
        return new LineString($points);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createPolygon($dimension, array $lineStrings, $srid = null): Polygon
    {
        return new Polygon($lineStrings);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createMultiPoint($dimension, array $points, $srid = null): MultiPoint
    {
        return new MultiPoint($points);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createMultiLineString($dimension, array $lineStrings, $srid = null): MultiLineString
    {
        return new MultiLineString($lineStrings);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     */
    public function createMultiPolygon($dimension, array $polygons, $srid = null): MultiPolygon
    {
        return new MultiPolygon($polygons);
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     * @return null
     */
    public function createLinearRing($dimension, array $points, $srid = null)
    {
        return null;
    }

    /**
     * @param string $dimension
     * @param ?int $srid
     * @return null
     */
    public function createGeometryCollection($dimension, array $geometries, $srid = null)
    {
        return null;
    }
}
