<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\ErrorHandling\Validator;

use Neos\Error\Messages\Result;
use Neos\Flow\Validation\Validator\ValidatorInterface;

/**
 * Wrapping validator that also allows null values.
 * If the given value is null, then it is always valid.
 * If not, then it is validated by the inner validator.
 */
class NullableValidator implements ValidatorInterface
{

    /** @var ValidatorInterface */
    private $wrapped;

    public function __construct(ValidatorInterface $wrapped)
    {
        $this->wrapped = $wrapped;
    }

    public function validate($value): Result
    {
        if ($value === null) {
            return new Result();
        }

        return $this->wrapped->validate($value);
    }

    public function getOptions(): array
    {
        return $this->wrapped->getOptions();
    }
}
