<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

use Doctrine\ORM\QueryBuilder;
use Newland\Toubiz\Sync\Neos\Domain\Filter\FilterInterface;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Uri;

/**
 * @Flow\Scope("singleton")
 *
 * @method Uri|null findOneByOriginalId(string $originalId)
 * @method Uri|null findByIdentifier(string $identifier)
 * @method Uri|null findOneBy(array $criteria, array $orderBy = null)
 */
class UriRepository extends AbstractRepository
{

    protected function applyFilter(FilterInterface $filter, QueryBuilder $query): QueryBuilder
    {
        return $query;
    }
}
