<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;

trait HasDetailUri
{

    /**
     * @ORM\Column(nullable=true)
     * @var string|null Specific detail URI for this article.
     */
    protected $detailUri;

    public function setDetailUri(?string $detailUri): void
    {
        $this->detailUri = $detailUri;
    }

    public function getDetailUri(): ?string
    {
        return $this->detailUri;
    }
}
