<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\Concern\SlopeConstants;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_slope_import_ident", columns={"originalid"})
 * })
 * @deprecated This model will be removed in the future.
 */
class Slope extends AbstractEntity implements SlopeConstants
{
    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Region",
     *     mappedBy="slopes",
     *     fetch="LAZY"
     * )
     * @var Collection<int, Region>
     */
    protected $regions;

    /** @var string */
    protected $name;

    /** @var int */
    protected $status;

    /**
     * @var int|null
     * @ORM\Column(nullable=true)
     */
    protected $type;

    /**
     * @var int|null
     * @ORM\Column(nullable=true)
     */
    protected $difficulty;

    /**
     * @var \DateTime|null
     */
    protected $updatedAt;


    public function __construct()
    {
        $this->regions = new ArrayCollection();
    }

    public function getIsOpen(): bool
    {
        return in_array($this->status, self::DEFINITION_STATUS_OPEN, true);
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setType(?int $type): void
    {
        $this->type = $type;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setStatus(int $status): void
    {
        $this->status = $status;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setDifficulty(?int $difficulty): void
    {
        $this->difficulty = $difficulty;
    }

    public function getDifficulty(): ?int
    {
        return $this->difficulty;
    }

    public function setUpdatedAt(?\DateTime $updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }

    public function getUpdatedAt(): ?\DateTime
    {
        return $this->updatedAt;
    }
}
