<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class ArticleList
{
    /**
     * @var string
     */
    protected $title = '';
    /**
     * @var string[]
     */
    protected $articleIdentifiers = [];
    /**
     * @var string[]
     */
    protected $categoryIdentifiers = [];

    public function __construct(string $title = '', array $articleIdentifiers = [], array $categoryIdentifiers = [])
    {
        $this->title = $title;
        $this->articleIdentifiers = $articleIdentifiers;
        $this->categoryIdentifiers = $categoryIdentifiers;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getArticleIdentifiers(): array
    {
        return $this->articleIdentifiers;
    }

    public function getCategoryIdentifiers(): array
    {
        return $this->categoryIdentifiers;
    }
}
