<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

/**
 * This model hold persistent per-record configuration. This information is moved into it's own
 * model that has no hard relationships to the original records in order to preserve the ability
 * to remove all records and reimport without loosing this configuration.
 *
 * It will be re-evaluated upon import in order to modify the record before saving it.
 *
 * @Flow\Entity()
 */
class RecordConfiguration
{
    use PersistenceObjectIdentifier;

    /** @var array */
    protected $configuration = [];

    public function getConfiguration(): array
    {
        return $this->configuration;
    }

    public function setConfiguration(array $configuration): void
    {
        $this->configuration = $configuration;
    }
}
