<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model\OpeningTimes;

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\AbstractEntity;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Flow\Entity()
 */
class KitchenTime extends AbstractEntity
{
    /**
     * @var \DateTime|null
     * @ORM\Column(type="time", name="`from`", nullable=true)
     */
    protected $from;

    /**
     * @var \DateTime|null
     * @ORM\Column(type="time", name="`to`", nullable=true)
     */
    protected $to;

    /** @var string */
    protected $comment;

    /**
     * @var Article
     * @ORM\ManyToOne(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Article", inversedBy="kitchenTimes")
     */
    protected $article;

    /**
     * @var int
     */
    protected $sorting;

    public function getFrom(): ?\DateTime
    {
        return $this->from;
    }

    public function setFrom(?\DateTime $from): void
    {
        $this->from = $from;
    }

    public function getTo(): ?\DateTime
    {
        return $this->to;
    }

    public function setTo(?\DateTime $to): void
    {
        $this->to = $to;
    }

    public function getComment(): string
    {
        return $this->comment;
    }

    public function setComment(string $comment): void
    {
        $this->comment = $comment;
    }

    public function getArticle(): ?Article
    {
        return $this->article;
    }

    public function setArticle(Article $article): void
    {
        $this->article = $article;
    }

    public function getSorting(): int
    {
        return $this->sorting;
    }

    public function setSorting(int $sorting): void
    {
        $this->sorting = $sorting;
    }
}
