<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
 use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_file_import_ident", columns={"originalid"})
 * })
 */
class File extends AbstractEntity
{
    /** @var string */
    protected $name;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    protected $sourceUri;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="files", fetch="LAZY")
     * @var Collection<int, Article>
     */
    protected $articles;

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setSourceUri(string $sourceUri): void
    {
        $this->sourceUri = $sourceUri;
    }

    public function getSourceUri(): string
    {
        return $this->sourceUri;
    }
}
