<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Configuration;

class ConfigurationAction
{
    /** @var string */
    private $name;

    /** @var string */
    private $icon;

    /** @var string */
    private $color;

    /** @var callable */
    private $action;

    public function __construct(string $name, string $icon, string $color, callable $action)
    {
        $this->name = $name;
        $this->action = $action;
        $this->icon = $icon;
        $this->color = $color;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getIcon(): string
    {
        return $this->icon;
    }

    public function getColor(): string
    {
        return $this->color;
    }

    public function invoke(array $configuration): array
    {
        $action = $this->action;
        return $action($configuration);
    }
}
