<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Tests\Unit\Serialization\Mocks;

use Newland\Toubiz\Map\Neos\Provider\Contract\FilterItemProvider;
use Newland\Toubiz\Map\Neos\Provider\Contract\MarkerProvider;
use Newland\Toubiz\Map\Neos\Provider\Contract\ProviderContext;

class MockProvider implements MarkerProvider, FilterItemProvider
{
    public static $filterItems = [];
    public static $filterItemCacheKey = null;
    public static $markers = [];
    public static $markerCacheKey = null;

    public static function reset(): void
    {
        static::$filterItems = [];
        static::$filterItemCacheKey = null;
        static::$markers = [];
        static::$markerCacheKey = null;
    }

    public function getFilterItems(ProviderContext $context): array
    {
        return self::$filterItems;
    }

    public function filterItemCacheKey(ProviderContext $context): ?string
    {
        return self::$filterItemCacheKey;
    }

    public function getMarkers(ProviderContext $context, int $offset, int $limit): array
    {
        return array_slice(self::$markers, $offset, $limit);
    }

    public function markerCacheKey(ProviderContext $context): ?string
    {
        return self::$markerCacheKey;
    }

    public function getNumberOfMarkers(ProviderContext $context): int
    {
        return count(self::$markers);
    }
}
