<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Tests\Unit\Serialization\Markers;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Neos\Domain\Model\Site;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Map\Neos\Provider\Contract\Marker;

class MarkerSerializerTestCase extends FunctionalTestCase
{
    use InteractsWithNodes;
    protected static $testablePersistenceEnabled = true;

    /** @var Node */
    protected $node;

    /** @var Node */
    protected $filterItem;

    /** @var Site */
    protected $site;

    /** @var Node */
    protected $mapNode;

    public function setUp(): void
    {
        parent::setUp();

        // Building the following structure:
        // Site root
        //  |> Site index page
        //    |> Map
        //      |> Filter Item
        $this->site = $this->initializeSite('foo');
        $nodes = $this->nodes([
              '/sites/foo' => [ 'nodeType' => 'Neos.NodeTypes:Page' ],
              '/sites/foo/main' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
              '/sites/foo/main/map' => [ 'nodeType' => 'Newland.Toubiz.Map.Neos:Map' ],
              '/sites/foo/main/map/children' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
              '/sites/foo/main/map/children/filter-item' => [ 'nodeType' => 'Newland.Toubiz.Map.Neos:Map.FilterItem' ],
              '/sites/foo/main/map/children/filter-item/children' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
          ], [
              'workspaceName' => 'live',
              'site' => $this->site,
              'language' => 'de',
          ]);
        $this->node = $nodes['/sites/foo'];
        $this->filterItem = $nodes['/sites/foo/main/map/children/filter-item'];
        $this->mapNode = $nodes['/sites/foo/main/map'];
    }

    /** @param Marker $marker */
    protected function assertIsValidSerializedMarker($marker): void
    {
        $this->assertInstanceOf(Marker::class, $marker);

        // Required fields
        $this->assertIsArray($marker->paths);
        $this->assertIsString($marker->paths[0]);
        $this->assertIsString($marker->title);
        $this->assertIsFloat($marker->longitude);
        $this->assertIsFloat($marker->latitude);

        // Optional keys
        $this->assertTrue(\is_string($marker->outdoorActiveTrackingId) || $marker->outdoorActiveTrackingId === null);
        $this->assertTrue(\is_string($marker->categoryTitle) || $marker->categoryTitle === null);
        $this->assertTrue(\is_string($marker->url) || $marker->url === null);
        $this->assertTrue(\is_array($marker->imageUrl) || $marker->imageUrl === null);
        $this->assertTrue(\is_array($marker->imageAlt) || $marker->imageAlt === null);
        $this->assertTrue(\is_array($marker->defaultStyle) || $marker->defaultStyle === null);
        $this->assertTrue(\is_array($marker->tour) || $marker->tour === null);
    }

}
