<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\ViewHelpers;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use TYPO3Fluid\Fluid\Core\ViewHelper\TagBuilder;

class IconViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'svg';

    public function render(string $id): string
    {
        $this->tag->addAttribute('class', 'c-icon');
        $this->tag->setContent($this->getUseTag($id));
        return $this->tag->render();
    }

    private function getUseTag(string $iconId): string
    {
        $use = new TagBuilder('use');
        $use->addAttribute('xlink:href', sprintf('#%s', $iconId));
        return $use->render();
    }
}
