<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Contract;

interface MarkerProvider
{
    public function getNumberOfMarkers(ProviderContext $context): int;

    /** @return Marker[] */
    public function getMarkers(ProviderContext $context, int $offset, int $limit): array;

    /**
     * Return a cache key that identifies the cache entry for this provider.
     *
     * The result of `getMarkers` will be saved under this cache key for future calls
     * to the provider. This can be useful, if the generation of the markers uses a lot
     * of resources.
     *
     * Return `null` if you want to disable caching for this provider.
     */
    public function markerCacheKey(ProviderContext $context): ?string;
}
