<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Contract;

interface FilterItemProvider
{
    /** @return FilterItem[] */
    public function getFilterItems(ProviderContext $context): array;

    /**
     * Return a cache key that identifies the cache entry for this provider.
     *
     * The result of `getFilterItems` will be saved under this cache key for future calls
     * to the provider. This can be useful, if the generation of the filter items uses a lot
     * of resources.
     *
     * Return `null` if you want to disable caching for this provider.
     */
    public function filterItemCacheKey(ProviderContext $context): ?string;
}
