<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Migration;

use Neos\ContentRepository\Domain\Model\NodeData;
use Neos\ContentRepository\Migration\Transformations\TransformationInterface;

class CastCoordinatesToFloat implements TransformationInterface
{
    protected const LAT = 'toubizMapLatitude';
    protected const LNG = 'toubizMapLongitude';

    public function isTransformable(NodeData $node)
    {
        return $node->hasProperty(self::LAT)
            && $node->hasProperty(self::LNG);
    }

    public function execute(NodeData $node)
    {
        // Note: 'floats' are still saved as strings in the database.
        // This just assures that these strings have the correct format.

        if ($node->hasProperty(self::LAT)) {
            $node->setProperty(
                self::LAT,
                (string) (float) $node->getProperty(self::LAT)
            );
        }

        if ($node->hasProperty(self::LNG)) {
            $node->setProperty(
                self::LNG,
                (string) (float) $node->getProperty(self::LNG)
            );
        }

        return $node;
    }
}
