<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Neos\Flow\Annotations as Flow;
use Newland\NeosIcons\IconUtility;

class IconDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-map-neos-icons';

    /**
     * @var IconUtility
     * @Flow\Inject()
     */
    protected $iconUtility;

    public function getData(NodeInterface $node = null, array $arguments)
    {
        $iconArray = array_map(
            function (string $icon) {
                return [
                    'label' => $icon,
                    'value' => $icon,
                    'icon' => (strpos($icon, '-solid'))
                                ? 'fas fa-' . str_replace('-solid', '', $icon)
                                : $icon,
                ];
            },
            array_keys($this->iconUtility->listAllAvailableIcons())
        );

        usort($iconArray, function ($a, $b) {
            return $a['label'] <=> $b['label'];
        });

        return $iconArray;
    }
}
