<?php declare(strict_types=1);


namespace Newland\NeosViewHelpers\Tests\Mock;


use Neos\Flow\Log\ThrowableStorageInterface;

class ThrowableStorageMock implements ThrowableStorageInterface
{
    public $loggedThrowables = [];

    /**
     * Writes information about the given exception into the log.
     *
     * @param \Throwable $throwable The throwable to log
     * @param array $additionalData Additional data to log
     * @return string Informational message about the stored throwable
     * @api
     */
    public function logThrowable(\Throwable $throwable, array $additionalData = [])
    {
        $this->loggedThrowables[] = $throwable;
    }

    /**
     * Set a closure that returns information about the current request to be stored with the exception.
     * Note this is not yet public API and bound to change.
     *
     * @param \Closure $requestInformationRenderer
     * @return self
     */
    public function setRequestInformationRenderer(\Closure $requestInformationRenderer)
    {
        // Dose nothing
    }

    /**
     * Set a closure that takes a backtrace array and returns a representation useful for this storage.
     * Note this is not yet public API and bound to change.
     *
     * @param \Closure $backtraceRenderer
     * @return self
     */
    public function setBacktraceRenderer(\Closure $backtraceRenderer)
    {
        // Does nothing
    }
}