<?php
namespace Newland\NeosMetaTags\Tests\Unit\Extractor;

use Neos\Flow\Tests\UnitTestCase;
use Newland\NeosMetaTags\Domain\Model\Scenario;
use Newland\NeosMetaTags\Extractor\RequestExtractor;
use Newland\NeosMetaTags\Tests\Unit\Record;

class RequestExtractorTest extends UnitTestCase
{
    /**
     * @var RequestExtractor
     */
    protected $subject;

    public function setUp(): void
    {
        $this->subject = new RequestExtractor();
    }

    /**
     * @dataProvider descriptionMappingExamples
     */
    public function testDescriptionExtractionHandlesStringAndArrayConfiguration($mapping, $recordData, $expected): void
    {
        $scenario = new Scenario();
        $scenario->setPropertyMapping([ 'description' => $mapping ]);

        $record = new Record(
            $recordData[0],
            $recordData[1],
            $recordData[2]
        );

        $this->assertEquals($expected, $this->subject->extractMetaDescription($scenario, $record));
    }

    public function descriptionMappingExamples(): array
    {
        return [
            [
                'abstract',
                [ '', 'barAbstract', 'bazDescription' ],
                'barAbstract',
            ],
            [
                'description',
                [ '', 'barAbstract', 'bazDescription' ],
                'bazDescription',
            ],
            [
                [ 'abstract', 'description' ],
                [ '', 'barAbstract', 'bazDescription' ],
                'barAbstract',
            ],
            [
                [ 'abstract', 'description' ],
                [ '', '', 'bazDescription' ],
                'bazDescription',
            ],
        ];
    }
}
