<?php
namespace Newland\NeosMetaTags\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\NeosCommon\Eel\Helper\NodeUtilityHelper;
use Neos\Flow\Annotations as Flow;
use Newland\NeosMetaTags\Eel\Helper\MetaDataHelper;
use Newland\NeosMetaTags\Service\MetaDataService;

class NodeTitleViewHelper extends AbstractViewHelper
{
    /**
     * @var MetaDataService
     * @Flow\Inject()
     */
    protected $metaDataService;

    public function render(Node $node): string
    {
        return (string) $this->metaDataService->getTitle($node, $this->controllerContext->getRequest());
    }
}
