<?php
namespace Newland\NeosMetaTags\Parser;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Mvc\ActionRequest;
use Newland\NeosMetaTags\Domain\Model\MetaData;
use Newland\NeosMetaTags\Domain\Model\Scenario;

class RequestParser
{

    protected function pluginParametersMatchWithScenario(array $pluginParameters, array $scenario): bool
    {
        return ($pluginParameters['@controller'] ?? null) === strtolower($scenario['controller'])
            && ($pluginParameters['@package'] ?? null) === strtolower($scenario['package'])
            && ($pluginParameters['@action'] ?? null) === strtolower($scenario['action'])
            && array_key_exists($scenario['parameter'], $pluginParameters);
    }

    /**
     * @param ActionRequest $request
     * @param array $scenarios
     * @return Scenario|null
     */
    public function getActiveScenario(ActionRequest $request, array $scenarios = []): ?Scenario
    {
        foreach ($request->getPluginArguments() as $pluginNamespace => $pluginParameters) {
            foreach ($scenarios as $scenarioValues) {
                if ($this->pluginParametersMatchWithScenario($pluginParameters, $scenarioValues)) {
                    $scenario = new Scenario();
                    $scenario->setObjectType($scenarioValues['objectType']);
                    $scenario->setRecordIdentifier($pluginParameters[$scenarioValues['parameter']]['__identity']);
                    $scenario->setOgType($scenarioValues['ogType'] ?? MetaData::OG_TYPE_DEFAULT);
                    $scenario->setPropertyMapping($scenarioValues['propertyMapping'] ?? []);
                    $scenario->setUrl($request->getHttpRequest()->getUri());
                    $scenario->setCanonicalUrlGenerator($scenarioValues['canonicalUrlGenerator'] ?? null);
                    $scenario->setNodePath($request->getArgument('node'));
                    return $scenario;
                }
            }
        }

        return null;
    }

    public function isDetailRequest(ActionRequest $request, array $scenarios = []): bool
    {
        foreach ($request->getPluginArguments() as $pluginNamespace => $pluginParameters) {
            foreach ($scenarios as $scenarioValues) {
                if ($this->pluginParametersMatchWithScenario($pluginParameters, $scenarioValues)) {
                    return true;
                }
            }
        }

        return false;
    }
}
